/*
 * Decompiled with CFR 0.152.
 */
package com.james.tinkerscalibration.modifiers;

import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.armor.DamageBlockModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.display.DurabilityDisplayModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.InventoryTickModifierHook;
import slimeknights.tconstruct.library.modifiers.impl.DurabilityShieldModifier;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.context.EquipmentContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.tools.modifiers.slotless.OverslimeModifier;

public class OvershieldModifier
extends DurabilityShieldModifier
implements InventoryTickModifierHook,
DurabilityDisplayModifierHook,
DamageBlockModifierHook {
    private final ResourceLocation KEY = new ResourceLocation("tinkerscalibration", "overshield_cooldown");

    public int getPriority() {
        return 1000;
    }

    public boolean fireImmune(Player player) {
        return player.m_5825_() || player.m_21023_(MobEffects.f_19607_);
    }

    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        hookBuilder.addHook((Object)this, ModifierHooks.INVENTORY_TICK, ModifierHooks.DURABILITY_DISPLAY, ModifierHooks.DAMAGE_BLOCK);
    }

    public boolean isDamageBlocked(IToolStackView tool, ModifierEntry modifier, EquipmentContext context, EquipmentSlot slotType, DamageSource source, float amount) {
        Player player;
        LivingEntity livingEntity = context.getEntity();
        if (livingEntity instanceof Player && !(player = (Player)livingEntity).m_7500_()) {
            int current = this.getShield(tool);
            int level = modifier.getLevel();
            int value = Math.round(amount);
            if (current >= value && !source.m_19378_()) {
                if (amount <= 40.0f) {
                    if (player.f_19802_ == 0 || source.m_19384_() && this.fireImmune(player)) {
                        this.addShield(tool, modifier, -value);
                        player.f_19802_ += 10;
                    }
                    return true;
                }
                this.addShield(tool, modifier, -this.getShieldCapacity(tool, modifier));
                player.m_36335_().m_41524_(tool.getItem(), 100);
                return false;
            }
            this.addShield(tool, modifier, -this.getShieldCapacity(tool, modifier));
            player.m_36335_().m_41524_(tool.getItem(), 100);
        }
        return false;
    }

    public int getShieldCurrent(IToolStackView tool) {
        return this.getShield(tool);
    }

    public void onInventoryTick(@Nonnull IToolStackView tool, ModifierEntry modifier, @Nonnull Level world, @Nonnull LivingEntity holder, int itemSlot, boolean isSelected, boolean isCorrectSlot, ItemStack stack) {
        if (!world.f_46443_ && holder.f_19797_ % 10 == 0 && holder instanceof Player) {
            Player player = (Player)holder;
            OverslimeModifier overslime = (OverslimeModifier)TinkerModifiers.overslime.get();
            int level = modifier.getLevel();
            int current = overslime.getShield(tool);
            if (current > 0 && this.getShield(tool) < this.getShieldCapacity(tool, modifier) && !player.m_36335_().m_41519_(tool.getItem())) {
                this.addShield(tool, modifier, 1);
                overslime.addOverslime(tool, modifier, -1);
            }
        }
    }

    @Nullable
    public Boolean showDurabilityBar(IToolStackView tool, ModifierEntry modifier) {
        return this.getShield(tool) > 0;
    }

    public int getShieldCapacity(IToolStackView tool, ModifierEntry modifier) {
        return 40 + 15 * modifier.getLevel();
    }

    public int getDurabilityRGB(IToolStackView tool, ModifierEntry modifier) {
        int level = modifier.getLevel();
        if ((float)this.getShield(tool) > 0.5f * (float)this.getShieldCapacity(tool, modifier)) {
            return 11403055;
        }
        if ((float)this.getShield(tool) > 0.25f * (float)this.getShieldCapacity(tool, modifier)) {
            return 0xFFDD00;
        }
        if (this.getShield(tool) > 0) {
            return 0xFF0000;
        }
        return -1;
    }
}

